//	Critical Mass Be
//	started 12/7/1997
//	Hamish Carr

#pragma once

class CMBrain;								//	forward declaration

#include <stdlib.h>							//	needed for randomization						
#include "CMBoard.h"						//	include the CMBoard declaration

class CMBrainParms							//	used internally for passing parameters for move
	{
	public:
	CMBoard *sourceBoard;					//	the board to take as source
	int row;								//	which row to consider
	int depth;							//	how many levels deep to look
	BStatusBar *theStatusBar;				//	where to send update results
	int *result;							//	where to put the results of thought
	bool isFirstTurn;						//	whether it is the first turn
	
	CMBrainParms(CMBoard *newSourceBoard, int newRow, int newDepth, 
			BStatusBar *newStatusBar, int *newResult, bool newIsFirstTurn = false);
										//	constructor
	}; // end of class BrainParms

class CMBrain								//	class encapsulating game brain
	{							  
	private:
	thread_id the_threads[N_ROWS];			//	for keeping track of threads
										//	global, to allow clean-up later
	public:										
	CMBrain();							//	default constructor
	
	void RandomBlue(CMBoard *sourceBoard, int *row, int *col);
										//	thinks up a blue move - returns 
										//	coordinates in the parameters
										//	currently a random brain


	void RandomRed(CMBoard *sourceBoard,int *row, int *col);
										//	thinks up a red move - returns 
										//	coordinates in the parameters
										//	currently a random brain

	void SmartBlue(CMBoard *sourceBoard,int *row, int *col);	
										//	thinks up a blue move - returns 
										//	coordinates in the parameters
										//	returns value of best move

	void SmartRed(CMBoard *sourceBoard,int *row, int *col, bool isFirstTurn = false);
										//	thinks up a red move - returns 
										//	coordinates in the parameters
										//	returns value of best move
										
	void ThreadedMinMaxBlue(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar);
										//	threaded brain to do bounded minmax search for blue

	void ThreadedMinMaxRed(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar, bool isFirstTurn = false);
										//	threaded brain to do bounded minmax search for blue

	static long MinMaxRowBlue(void *theBrainParms);
										//	static so that we can pass it to a thread

	static long MinMaxRowRed(void *theBrainParms);
										//	static so that we can pass it to a thread

	void MinMaxBlue(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar);
										//	does a bounded minmax search for blue
	
	void MinMaxRed(CMBoard *sourceBoard, int *row, int *col, int depth, BStatusBar *theStatusBar, bool isFirstTurn = false);
										//	does a bounded minmax search for red

	long MinMaxDeeperBlue(CMBoard *theBoard, int depth);
										//	does deeper levels, where we don't care about row, col
	
	long MinMaxDeeperRed(CMBoard *theBoard,int depth);
										//	does deeper levels, where we don't care about row, col
	
	void kill_threads();					//	used for destroying threads
	}; // end of class CMBrain

CMBrain aBrain;							//	an empty brain for use in threaded versions